from collections import defaultdict

def solve():
    import sys
    input = sys.stdin.readline

    n = int(input())
    points = [tuple(map(int, input().split())) for _ in range(n)]

    greetings = 1

    by_y = defaultdict(list)
    for x, y in points:
        by_y[y].append(x)
    for xs in by_y.values():
        even, odd = 0, 0
        for x in xs:
            if x % 2 == 0:
                even += 1
            else:
                odd += 1
        greetings += even * (even - 1) // 2
        greetings += odd * (odd - 1) // 2

    by_x = defaultdict(list)
    for x, y in points:
        by_x[x].append(y)
    for ys in by_x.values():
        even, odd = 0, 0
        for y in ys:
            if y % 2 == 0:
                even += 1
            else:
                odd += 1
        greetings += even * (even - 1) // 2
        greetings += odd * (odd - 1) // 2
    by_diag1 = defaultdict(int)
    for x, y in points:
        key = x - y
        greetings += by_diag1[key]
        by_diag1[key] += 1
    by_diag2 = defaultdict(int)
    for x, y in points:
        key = x + y
        greetings += by_diag2[key]
        by_diag2[key] += 1

    print(greetings)


if __name__ == "__main__":
    solve()